#ifndef LIST_H
#define LIST_H

#include<iostream.h>
#include<assert.h>
#include<fstream.h>

template <class T>

class List;

//-------------------------------- N O D E  C L A S S -----------------------------------

template <class T>

class Node
{
	friend class List<T>;

	public:
		Node()
		{			
			Service_Time=0;
			Arrival_Time=0;
			next=NULL;
		}

		Node(const T &id ,const int a_time ,const int s_time)
		{
			Customer_Id=id;
			Service_Time=s_time;
			Arrival_Time=a_time;	

			next=NULL;
		}

		Node(const T &id, const int a_time ,const int s_time ,  Node<T> *n)
		{
			Customer_Id=id;
			Service_Time=s_time;
			Arrival_Time=a_time;			
			
			next=n;
		}		

	private:
		T Customer_Id;		
		int Service_Time;
		int Arrival_Time;
		
		Node<T> *next;
};

//-------------------------------- L I S T  C L A S S --------------------------------------

template <class T>

class List
{
	public:
		List()
		{
			Head=NULL;
			Tail=NULL;
			size=0;
		}

		List(const List<T> &);
		~List();
		void Delete_List();
		void Insert_Node(const T & , const int , const int);
		void Delete_Node(const T &);
		void Display_List(ofstream&) const;

		int Get_size() const
		{
			return size;
		}

		List& operator = (const List<T> &);

	private:
		Node<T> *Head;
		Node<T> *Tail;

		int size;
};

template <class T>

List<T>::~List()
{
	Delete_List();
	size=0;
}

template <class T>

void List<T>::Delete_List()
{
	if (Head!=NULL)
	{
		Node<T> *currentptr=Head;
		Node<T> *tempptr;

		while (currentptr!=0)
		{
			tempptr=currentptr;
			currentptr=currentptr->next;			
			delete tempptr;
		}
	}	
	Head=NULL;
}

template <class T>

void List<T> :: Insert_Node(const T &id , const int a_time ,const int s_time)
{
	Node<T> *newptr=new Node<T>(id , a_time , s_time);
	assert(newptr!=0);

	if (Head==0)
	{
		Head=newptr;
		Tail=newptr;
	}
	else
	{
		Tail->next=newptr;
		Tail=newptr;
	}
	size++;
}

template <class T>

void List<T> :: Delete_Node(const T &id)
{
	if (Head==0)
	{
		cout<<"\n error : THE LIST IS EMPTY !";
	}
	else
	{
		Node<T> *Fatherptr=Head;
		Node<T> *Sonptr=Head->next;

		if (Fatherptr->Customer_Id==id)
		{
			Head=Head->next;
		}
		else
		{
			while (Sonptr!=NULL)
			{
				if (Sonptr->Customer_Id==id)
				{
					Fatherptr->next=Sonptr->next;
				}	

				Sonptr=Sonptr->next;
				Fatherptr=Fatherptr->next;
			}
		}
	}
}

template <class T>

void List<T> :: Display_List(ofstream& outFile) const 
{
	if (Head==0)
		outFile<<"error : THE LIST IS EMPTY ! \n";

	else
	{
		Node<T> *currentptr=Head;		

		outFile<<"\n\n\t\tC U S T O M E R  L I S T"<<endl;
		outFile<<"\t\t------------------------"<<endl<<endl;

		while (currentptr !=NULL)
		{
			outFile<<"Customer Id	:"<<currentptr->Customer_Id<<endl;
			outFile<<"---------------------"<<endl<<endl;
			outFile<<"Arrival Time	:"<<currentptr->Arrival_Time<<endl;			
			outFile<<"Service Time	:"<<currentptr->Service_Time<<endl<<endl;
			currentptr=currentptr->next;
		}		
	}
}

template <class T>

List<T> :: List(const List<T> &original)
{
	size=original.size;

	Node<T> *ptr=original.Head;
	Node<T> *newptr , *lastptr;

	while(ptr!=NULL);
	{
		newptr=new Node<T>(ptr->Customer_Id , ptr->Waiting_Time , ptr->Service_Time);
		assert(newptr!=0);

		if (Head==0)
			Head=newptr;
		else
			lastptr->next=newptr;

		lastptr=newptr;
		ptr=ptr->next;
	}
}

template <class T>

List<T>& List<T> :: operator=(const List<T> &original)
{
	if (this!=&original)
	{
		deleteList();

		size=original.size;
		Head=0;
		Node<T> *ptr=original.Head;
		Node<T> *newptr , *lastptr;

		while(ptr!=0);
		{
			newptr=new Node<T>(ptr->Customer_Id , ptr->Waiting_Time , ptr->Service_Time);
			assert(newptr!=0);

			if (Head==0)
				Head=newptr;
			else
				lastptr->next=newptr;

			lastptr=newptr;
			ptr=ptr->next;
		}
	}
}

#endif